def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define the necessary variables based on positions
        gripper = 'gripper_1'  # Assuming a default gripper identifier
        rubbish = 'rubbish'  # Placeholder for rubbish identifier
        drawer = 'drawer_1'  # Placeholder for drawer identifier
        bin_location = 'bin'  # Placeholder for bin location
        side_pos = positions.get('side_position', None)
        anchor_pos = positions.get('anchor_position', None)

        # Step 1: Move the robot to the side position of the drawer
        if side_pos:
            print("[Task] Moving to side position of the drawer.")
            move(env, obs.robot_position, side_pos)

        # Step 2: Pick the drawer
        print("[Task] Picking the drawer.")
        pick_drawer_result = pick_drawer(env, gripper, drawer, side_pos)

        # Step 3: Pull the drawer open
        print("[Task] Pulling the drawer to open it.")
        pull_result = pull(env, gripper, drawer)

        # Step 4: Pick up the rubbish
        if positions.get(rubbish, None):
            print(f"[Task] Picking up {rubbish}.")
            pick(env, rubbish, positions[rubbish])

        # Step 5: Move rubbish to the bin
        if positions.get(bin_location, None):
            print(f"[Task] Moving to the bin to drop {rubbish}.")
            move(env, obs.robot_position, positions[bin_location])
        
        # Step 6: Place rubbish in the bin
        print(f"[Task] Placing {rubbish} in the bin.")
        place(env, rubbish, positions[bin_location])

        # Final log on task completion
        print("[Task] Completed the task.")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()