def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Assume we have positions for the gripper and the drawer
        gripper_position = positions['gripper']
        drawer_position = positions['drawer']
        
        # 1) Move to the drawer position
        print(f"[Task] Moving to drawer position: {drawer_position}")
        obs, reward, done = move(env, 'current_location', drawer_position)

        if done:
            print("[Task] Task ended after moving to the drawer position!")
            return
        
        # 2) Pick the drawer
        print(f"[Task] Picking the drawer.")
        obs, reward, done = pick(env, 'drawer', drawer_position, 'gripper')

        if done:
            print("[Task] Task ended after picking the drawer!")
            return

        # 3) Open the drawer
        print(f"[Task] Pulling the drawer to open it.")
        obs, reward, done = pull(env, 'gripper', 'drawer', drawer_position)

        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

        # 4) Move gripper back to original position (if needed)
        print("[Task] Moving back to original position.")
        obs, reward, done = move(env, drawer_position, 'original_position')

        if done:
            print("[Task] Task ended after moving back to the original position!")
            return
            
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()