def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Example positions for the objects - replace with your actual object names
        room = 'rooma'
        rubbish = 'rubbish'
        drawer = 'drawer'
        
        # Positions
        side_pos_bottom = positions['bottom_side_pos']
        anchor_pos_bottom = positions['bottom_anchor_pos']
        
        # 1) Move to the side position of the drawer
        print("[Task] Moving to the Side Position of the Drawer:", side_pos_bottom)
        obs, reward, done = move(env, room, side_pos_bottom)
        if done:
            print("[Task] Task ended after moving to side position!")
            return
            
        # 2) Rotate to align the gripper with the drawer handle.
        print("[Task] Rotating Gripper to Align with the Drawer Handle.")
        obs, reward, done = rotate(env, task, target_quat=[0, 0, 0, 1])  # Adjust target_quat as necessary
        if done:
            print("[Task] Task ended after rotating the gripper!")
            return
        
        # 3) Pick the drawer handle
        print("[Task] Picking the Drawer Handle.")
        obs, reward, done = pick(env, drawer, room, 'gripper')
        if done:
            print("[Task] Task ended after picking the drawer handle!")
            return
        
        # 4) Open the drawer by pulling it
        print("[Task] Pulling to Open the Drawer.")
        obs, reward, done = pull(env, drawer)
        if done:
            print("[Task] Task ended after pulling to open the drawer!")
            return
        
        # 5) Place rubbish in the open drawer
        print("[Task] Placing Rubbish in the Drawer.")
        obs, reward, done = place(env, rubbish, drawer)
        if done:
            print("[Task] Task ended after placing rubbish in the drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()