def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Identifying drawer and rubbish position from the object positions
        drawer_pos = positions['drawer']
        rubbish_pos = positions['rubbish']
        gripper_pos = positions['gripper']

        # Step 1: Move close to the drawer
        print("[Task] Moving to the drawer position:", drawer_pos)
        obs, reward, done = move(env, gripper_pos, drawer_pos)
        if done:
            print("[Task] Task ended while moving to the drawer!")
            return
        
        # Step 2: Pick the drawer
        print("[Task] Picking the drawer")
        obs, reward, done = pick(env, 'drawer', drawer_pos, 'gripper')
        if done:
            print("[Task] Task ended while picking the drawer!")
            return

        # Step 3: Open the drawer
        print("[Task] Opening the drawer")
        obs, reward, done = pull(env, 'drawer', drawer_pos)
        if done:
            print("[Task] Task ended while opening the drawer!")
            return

        # Step 4: Move rubbish to the drawer
        print("[Task] Moving to rubbish position:", rubbish_pos)
        obs, reward, done = move(env, gripper_pos, rubbish_pos)
        if done:
            print("[Task] Task ended while moving to the rubbish!")
            return
        
        # Step 5: Pick the rubbish
        print("[Task] Picking the rubbish")
        obs, reward, done = pick(env, 'rubbish', rubbish_pos, 'gripper')
        if done:
            print("[Task] Task ended while picking the rubbish!")
            return

        # Step 6: Place rubbish in the drawer
        print("[Task] Placing rubbish in the drawer")
        obs, reward, done = place(env, 'rubbish', drawer_pos)
        if done:
            print("[Task] Task ended while placing the rubbish!")
            return
        
        print("[Task] Completed all actions successfully.")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()