def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        rubbish_pos = positions['rubbish']
        bin_pos = positions['bin']
        drawer_pos = positions['bottom']
        gripper_id = 'gripper'  # Assuming we have a gripper object

        # Step 1: Move to the drawer
        print("[Task] Moving to the drawer")
        obs, reward, done = move(env, gripper_id, obs.current_pos, drawer_pos)
        if done:
            print("[Task] Move to drawer completed!")
        
        # Step 2: Open the drawer
        print("[Task] Opening the drawer")
        obs, reward, done = pick(env, "drawer_handle", drawer_pos, gripper_id)  # Assuming 'drawer_handle' is picked
        if done:
            print("[Task] Picked drawer handle.")
            obs, reward, done = pull(env, gripper_id, "drawer")  # Assuming 'drawer' is opened
            if done:
                print("[Task] Drawer opened successfully!")

        # Step 3: Move to the rubbish
        print("[Task] Moving to the rubbish")
        obs, reward, done = move(env, gripper_id, drawer_pos, rubbish_pos)
        if done:
            print("[Task] Moved to rubbish location.")
        
        # Step 4: Pick up the rubbish
        print("[Task] Picking up the rubbish")
        obs, reward, done = pick(env, "rubbish", rubbish_pos, gripper_id)
        if done:
            print("[Task] Picked up the rubbish.")

        # Step 5: Move to the bin
        print("[Task] Moving to the bin")
        obs, reward, done = move(env, gripper_id, rubbish_pos, bin_pos)
        if done:
            print("[Task] Moved to the bin.")

        # Step 6: Place the rubbish in the bin
        print("[Task] Placing the rubbish in the bin")
        obs, reward, done = place(env, "rubbish", bin_pos)
        if done:
            print("[Task] Rubbish placed in the bin.")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()