def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")

    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Extract positions of relevant objects
        rubbish_pos = positions['rubbish']
        bin_pos = positions['bin']
        drawer_bottom_pos = positions['bottom_side_pos']
        drawer_anchor_pos = positions['bottom_anchor_pos']
        gripper = 'gripper'  # Assuming a single gripper object

        # Task Execution Steps
        # 1) Move to the bottom drawer to open it
        print("[Task] Moving to the bottom drawer")
        obs, reward, done = move(env, task, 'start_position', drawer_bottom_pos)

        if done:
            print("[Task] Task ended prematurely while moving to the drawer!")
            return

        # 2) Pick the drawer
        print("[Task] Picking the bottom drawer")
        obs, reward, done = pick_drawer(gripper, 'drawer_bottom', drawer_anchor_pos)

        if done:
            print("[Task] Task ended prematurely while picking the drawer!")
            return

        # 3) Pull the drawer open
        print("[Task] Pulling the drawer open")
        obs, reward, done = pull(gripper, 'drawer_bottom')

        if done:
            print("[Task] Task ended prematurely while pulling the drawer!")
            return

        # 4) Move to the rubbish
        print("[Task] Moving to the rubbish")
        obs, reward, done = move(env, task, drawer_bottom_pos, rubbish_pos)

        if done:
            print("[Task] Task ended prematurely while moving to rubbish!")
            return

        # 5) Pick the rubbish
        print("[Task] Picking the rubbish")
        obs, reward, done = pick(env, 'rubbish', rubbish_pos)

        if done:
            print("[Task] Task ended prematurely while picking rubbish!")
            return

        # 6) Move to the bin
        print("[Task] Moving to the bin")
        obs, reward, done = move(env, task, rubbish_pos, bin_pos)

        if done:
            print("[Task] Task ended prematurely while moving to bin!")
            return

        # 7) Place the rubbish in the bin
        print("[Task] Placing rubbish in the bin")
        obs, reward, done = place(env, 'rubbish', bin_pos)

        if done:
            print("[Task] Task ended prematurely while placing rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()