def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Objectives and predicates to check the robot's state
        gripper = "gripper1"
        drawer = "drawer1"
        initial_location = positions['initial_position']  # Replace as needed based on observation
        target_location = positions['target_position']  # Replace as needed based on observation

        # Step 1: Move to the initial position
        obs, reward, done = move(env, initial_location)
        if done:
            print("[Task] Ended while moving to the initial position!")
            return

        # Step 2: Gripper movement for drawer interaction
        obs, reward, done = rotate(env, task, target_quat=np.array([0, 0, 0, 1]))  # Adjust based on required orientation
        if done:
            print("[Task] Ended during rotation!")
            return

        # Step 3: Pick the drawer using the gripper
        obs, reward, done = pick(env, drawer, positions['drawer_location'], gripper)
        if done:
            print("[Task] Task ended after picking the drawer!")
            return

        # Step 4: Pulling the drawer open
        obs, reward, done = pull(env, drawer)  # Check that the drawer can be pulled
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

        # Step 5: Place the object in the specified location (replace 'object' with actual object name)
        obs, reward, done = place(env, "object", target_location)
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shut down
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()