def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a drawer and an object to manipulate
        drawer_pos = positions['drawer']
        object_pos = positions['object']
        
        # Step 1: Move to the drawer's position
        print(f"[Task] Moving to drawer position: {drawer_pos}")
        obs, reward, done = move(env, obs.current_position, drawer_pos)
        if done:
            print("[Task] Task ended after moving to the drawer!")
            return

        # Step 2: Rotate to the correct angle for picking from drawer
        print("[Task] Rotating gripper...")
        obs, reward, done = rotate(env, task, target_quat)  # Placeholder for actual target_quat
        if done:
            print("[Task] Task ended after rotating!")
            return
        
        # Step 3: Open the drawer to access the object
        print("[Task] Picking the drawer...")
        obs, reward, done = pick(env, 'drawer_handle', drawer_pos)
        if done:
            print("[Task] Task ended after picking the drawer handle!")
            return
            
        # Step 4: Pull the drawer open
        print("[Task] Pulling the drawer...")
        obs, reward, done = pull(env, 'drawer')
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return
        
        # Step 5: Pick the object inside the drawer
        print(f"[Task] Picking the object at: {object_pos}...")
        obs, reward, done = pick(env, 'object', object_pos)
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Step 6: Place the object at the target location (e.g., table)
        target_location = (2, 0, 0)  # Placeholder for actual target location
        print(f"[Task] Placing the object at: {target_location}...")
        obs, reward, done = place(env, 'object', target_location)
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()