def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Example positions for interaction
        gripper = 'gripper'
        drawer = 'drawer'
        bottom_side_pos = 'bottom_side_pos'
        bottom_anchor_pos = 'bottom_anchor_pos'

        # Execute the plan actions
        # Move the gripper to the side position of the drawer to pick it
        print("[Task] Moving gripper to side position of the drawer.")
        obs, reward, done = move(env, 'nowhere-pos', bottom_side_pos)

        if done:
            return
        
        # Pick the drawer
        print("[Task] Picking the drawer.")
        obs, reward, done = pick(env, drawer, bottom_side_pos, gripper)

        if done:
            return
        
        # Open the drawer
        print("[Task] Opening the drawer.")
        obs, reward, done = pull(env, gripper, drawer)

        if done:
            return
        
        # Rotate the gripper to position for placing the object
        print("[Task] Rotating the gripper.")
        target_quat = [0.0, 0.0, 0.0, 1.0]  # Example target quaternion
        obs, reward, done = rotate(env, task, target_quat)

        if done:
            return
        
        # Place the object in the drawer or the disposal
        print("[Task] Placing the object.")
        obs, reward, done = place(env, 'object_name', 'desired_location')

        if done:
            return
        
        print("[Task] Completed all actions successfully.")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()