def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Assuming that 'drawer', 'gripper', 'rubbish', and 'bin' are among the objects
        drawer_pos = positions['drawer']
        gripper_pos = positions['gripper']
        rubbish_pos = positions['rubbish']
        bin_pos = positions['bin']
        
        # Start executing the plan
        print(f"[Task] Moving to gripper location at: {gripper_pos}")
        obs, reward, done = move(env, gripper_pos[0], gripper_pos[1])

        if done:
            print("[Task] Task ended while moving to gripper!")
            return
        
        print("[Task] Picking up the rubbish.")
        obs, reward, done = pick(env, 'rubbish', rubbish_pos, 'gripper')

        if done:
            print("[Task] Task ended after picking up rubbish!")
            return

        print("[Task] Moving to bin location.")
        obs, reward, done = move(env, gripper_pos[0], bin_pos)

        if done:
            print("[Task] Task ended while moving to bin!")
            return

        print("[Task] Placing rubbish in the bin.")
        obs, reward, done = place(env, 'rubbish', bin_pos)

        if done:
            print("[Task] Task ended after placing rubbish!")
            return

        print("===== Successfully completed the task! =====")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()