def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define the locations and objects
        gripper = 'gripper'  # Assuming an existing gripper object in the environment
        drawer = 'drawer'  # Placeholder for the actual drawer object
        bin_location = 'bin'  # Placeholder for the rubbish bin location
        
        # Move to the drawer to pick up rubbish
        print("[Task] Moving to the drawer location...")
        obs, reward, done = move(env, obs.robot_location, positions[drawer])
        if done:
            print("[Task] Task ended after moving to the drawer!")
            return
        
        # Open the drawer
        print("[Task] Attempting to pick the drawer...")
        obs, reward, done = pick(env, drawer, positions[drawer], gripper)
        if done:
            print("[Task] Task ended after picking the drawer!")
            return

        # Pull the drawer open if not locked
        print("[Task] Performing the pull action to open the drawer...")
        obs, reward, done = pull(env, drawer)
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return
        
        # Pick the rubbish (assuming it's within the drawer's area)
        rubbish = 'rubbish'  # Placeholder for the actual rubbish object in the drawer
        print("[Task] Picking up the rubbish...")
        obs, reward, done = pick(env, rubbish, positions[drawer], gripper)
        if done:
            print("[Task] Task ended after picking up the rubbish!")
            return
        
        # Move to the bin to drop the rubbish
        print("[Task] Moving to the bin location to drop the rubbish...")
        obs, reward, done = move(env, positions[drawer], bin_location)
        if done:
            print("[Task] Task ended after moving to the bin!")
            return
            
        # Place the rubbish in the bin
        print("[Task] Dropping the rubbish in the bin...")
        obs, reward, done = place(env, rubbish, bin_location)
        if done:
            print("[Task] Task ended after dropping the rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()