def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Define the robot position and target object positions based on retrieved data
        robot_position = positions['robot']
        target_object_pos = positions['target_object']
        drawer_pos = positions['drawer']

        # 1) Move to the target object position
        print("[Task] Moving to target object position at:", target_object_pos)
        obs, reward, done = move(env, robot_position, target_object_pos)
        if done:
            print("[Task] Task ended during moving to target object!")
            return
        
        # 2) Pick the object from the target position
        print("[Task] Picking up the object at:", target_object_pos)
        obs, reward, done = pick(env, 'target_object', 'target_location', 'gripper')
        if done:
            print("[Task] Task ended after picking the target object!")
            return

        # 3) Move to the drawer position
        print("[Task] Moving to drawer position at:", drawer_pos)
        obs, reward, done = move(env, target_object_pos, drawer_pos)
        if done:
            print("[Task] Task ended during moving to drawer!")
            return
        
        # 4) Place the object into the drawer
        print("[Task] Placing the object into the drawer.")
        obs, reward, done = place(env, 'target_object', 'drawer_location')
        if done:
            print("[Task] Task ended after placing the object!")
            return
        
        print("[Task] Completed the robot task successfully.")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()