def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Assumed object and positions based on available details
        drawer_position = positions['drawer']
        object_position = positions['object']
        gripper_position = positions['gripper']

        # Start the task execution based on provided skills
        try:
            # Rotate gripper to zero degrees as per feedback
            rotate(env, task, target_quat=[0.0, 0.0, 0.0, 1.0])  # Quaternion for zero degree rotation
            print("[Task] Gripper rotated to zero degrees.")

            # Move to the drawer to pick it
            print("[Task] Moving to drawer position:", drawer_position)
            move(env, gripper_position, drawer_position)  # Adjust according to the expected parameters
            print("[Task] Reached drawer position.")

            # Pick the drawer
            pick(env, drawer, drawer_position)  # Pick the drawer using the skill
            print("[Task] Drawer picked successfully.")

            # Pull the drawer
            pull(env, drawer)  # Pull the drawer to open it
            print("[Task] Drawer pulled open.")

            # Move to the object position to pick it
            print("[Task] Moving to object position:", object_position)
            move(env, drawer_position, object_position)  # Move to the object position
            print("[Task] Reached object position.")

            # Pick the object
            pick(env, object, object_position)  # Pick the object using the skill
            print("[Task] Object picked successfully.")

            # Place the object back or into another location if needed
            # Assuming we would drop it back to a position, for now, we will place it
            place(env, object, object_position)  # Place the object back in the same position
            print("[Task] Object placed successfully.")

        except Exception as e:
            print(f"[Error] An exception occurred during the task execution: {e}")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()