def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # Retrieve Object Positions
        positions = get_object_positions()
        
        # Extract objects and locations from positions for actions
        ball_location = positions['ball']
        drawer_location = positions['drawer']

        # Step 1: Move to the ball location
        print("[Task] Moving to the ball location:", ball_location)
        obs, reward, done = move(env, task, "initial_room", ball_location)
        if done:
            print("[Task] Task ended after moving to the ball!")
            return
        
        # Step 2: Pick up the ball
        print("[Task] Picking up the ball")
        obs, reward, done = pick(env, "ball", ball_location, "gripper")
        if done:
            print("[Task] Task ended after picking the ball!")
            return
        
        # Step 3: Move to the drawer
        print("[Task] Moving to the drawer location:", drawer_location)
        obs, reward, done = move(env, task, ball_location, drawer_location)
        if done:
            print("[Task] Task ended after moving to drawer!")
            return
        
        # Step 4: Place the ball in the drawer
        print("[Task] Placing the ball in the drawer")
        obs, reward, done = place(env, "ball", drawer_location)
        if done:
            print("[Task] Task ended after placing the ball!")
            return

        # Step 5: Rotate gripper (if needed)
        print("[Task] Rotating the gripper")
        obs, reward, done = rotate(env, task, "target_quat")
        if done:
            print("[Task] Task ended after rotating the gripper!")
            return
        
        # End of Task
        print("[Task] Task completed successfully!") 

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()