def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # Optional: Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the objects of interest are 'bottom', 'rubbish', and 'bin'
        bottom_anchor_pos = positions['bottom_anchor_pos']
        bottom_side_pos = positions['bottom_side_pos']
        rubbish_pos = positions['rubbish']
        bin_pos = positions['bin']

        # Step 1: Move to the bottom drawer side position
        print("[Task] Moving to bottom side position.")
        obs, reward, done = move(env, 'robby', obs.gripper_pose[:3], bottom_side_pos)

        if done:
            print("[Task] Task ended after moving to bottom drawer side position!")
            return

        # Step 2: Rotate gripper to align with the drawer handle
        print("[Task] Rotating gripper to align with drawer handle.")
        obs = rotate(env, task, target_quat=[0, 0, 0, 1])  # Adjust quaternion as needed

        # Step 3: Pick the drawer
        print("[Task] Picking the bottom drawer.")
        obs, reward, done = pick(env, 'bottom_drawer', 'kitchen', 'gripper')

        if done:
            print("[Task] Task ended after picking the bottom drawer!")
            return

        # Step 4: Open the bottom drawer
        print("[Task] Pulling the bottom drawer to open it.")
        obs, reward, done = pull(env, 'robby', 'bottom_drawer', obs.gripper_pose[:3])

        if done:
            print("[Task] Task ended after pulling the bottom drawer!")
            return

        # Step 5: Move to the rubbish to pick it up
        print("[Task] Moving to rubbish.")
        obs, reward, done = move(env, 'robby', obs.gripper_pose[:3], rubbish_pos)

        if done:
            print("[Task] Task ended after moving to rubbish!")
            return

        # Step 6: Pick up the rubbish
        print("[Task] Picking up the rubbish.")
        obs, reward, done = pick(env, 'rubbish', 'room', 'gripper')

        if done:
            print("[Task] Task ended after picking up the rubbish!")
            return

        # Step 7: Move to the bin to dispose of the rubbish
        print("[Task] Moving to the bin to dispose of the rubbish.")
        obs, reward, done = move(env, 'robby', obs.gripper_pose[:3], bin_pos)

        if done:
            print("[Task] Task ended after moving to the bin!")
            return

        # Step 8: Place the rubbish in the bin
        print("[Task] Placing rubbish in the bin.")
        obs, reward, done = place(env, 'rubbish', 'bin')

        if done:
            print("[Task] Task ended after placing rubbish in the bin!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()