def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Example of specific objects we might interact with
        drawer_bottom_pos = positions['bottom']
        drawer_middle_pos = positions['middle']
        drawer_top_pos = positions['top']
        gripper_pos = positions['nowhere-pos']

        # Step 1: Move to the bottom drawer position and open it
        print("[Task] Moving to the bottom drawer...")
        obs, reward, done = move(env, gripper_pos, drawer_bottom_pos)
        if done:
            print("[Task] Task ended after moving to the bottom drawer!")
            return

        print("[Task] Picking the bottom drawer...")
        obs, reward, done = pick(env, 'bottom', drawer_bottom_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking the bottom drawer!")
            return
        
        print("[Task] Opening the bottom drawer...")
        obs, reward, done = pull(env, 'bottom', drawer_bottom_pos)
        if done:
            print("[Task] Task ended after pulling the bottom drawer!")
            return

        # Step 2: Move to the middle drawer position and open it
        print("[Task] Moving to the middle drawer...")
        obs, reward, done = move(env, drawer_bottom_pos, drawer_middle_pos)
        if done:
            print("[Task] Task ended after moving to the middle drawer!")
            return
        
        print("[Task] Picking the middle drawer...")
        obs, reward, done = pick(env, 'middle', drawer_middle_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking the middle drawer!")
            return
        
        print("[Task] Opening the middle drawer...")
        obs, reward, done = pull(env, 'middle', drawer_middle_pos)
        if done:
            print("[Task] Task ended after pulling the middle drawer!")
            return

        # Step 3: Move to the top drawer position and open it
        print("[Task] Moving to the top drawer...")
        obs, reward, done = move(env, drawer_middle_pos, drawer_top_pos)
        if done:
            print("[Task] Task ended after moving to the top drawer!")
            return
        
        print("[Task] Picking the top drawer...")
        obs, reward, done = pick(env, 'top', drawer_top_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking the top drawer!")
            return
        
        print("[Task] Opening the top drawer...")
        obs, reward, done = pull(env, 'top', drawer_top_pos)
        if done:
            print("[Task] Task ended after pulling the top drawer!")
            return

        # Step 4: Complete the task and dispose of rubbish
        print("[Task] Moving to disposal area...")
        disposal_pos = positions['disposal']
        obs, reward, done = move(env, gripper_pos, disposal_pos)
        if done:
            print("[Task] Task ended after moving to disposal area!")
            return 
        
        print("[Task] Placing the rubbish in the disposal...")
        obs, reward, done = place(env, 'rubbish', disposal_pos)
        if done:
            print("[Task] Completed the disposal of rubbish!")
            return

    finally:
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()