def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define the positions based on the object list in the environment
        bottom_anchor_pos = positions['bottom_anchor_pos']
        bottom_side_pos = positions['bottom_side_pos']
        trash_position = positions['bin']  # Or whatever the trash position is
        
        # === Robot Task Steps ===
        # Step 1: Move to the side position of the bottom drawer
        print("[Task] Moving to bottom side position.")
        obs = move(env, 'current_room', bottom_side_pos)

        # Step 2: Pick up the bottom drawer
        print("[Task] Picking up the bottom drawer.")
        obs = pick(env, 'bottom_drawer', 'current_room', 'gripper')

        # Step 3: Pull the bottom drawer open
        print("[Task] Pulling the bottom drawer open.")
        obs = pull(env, 'gripper', 'bottom_drawer')

        # Step 4: Move to the trash position with the rubbish
        print("[Task] Moving to the trash position to dispose of rubbish.")
        obs = move(env, 'current_room', trash_position)

        # Step 5: Place the rubbish in the trash
        print("[Task] Placing the rubbish in the trash.")
        obs = place(env, 'rubbish', trash_position)

        print("[Task] Task completed successfully.")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()