def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Get object positions from the environment
        bottom_anchor_pos = positions['bottom_anchor_pos']
        bottom_side_pos = positions['bottom_side_pos']
        rubbish_pos = positions['rubbish']
        bin_pos = positions['bin']
        
        # Start task plan
        print("[Task] Start unlocking and opening drawer...")
        
        # Move to the side position of the drawer
        obs, reward, done = move(env, task, target_pos=bottom_side_pos)
        if done:
            print("[Task] Task ended during moving to the side position!")
            return

        # Pick the drawer
        obs, reward, done = pick(env, task, obj='bottom', loc=bottom_side_pos)
        if done:
            print("[Task] Task ended during picking the drawer!")
            return

        # Pull the drawer to open it
        obs, reward, done = pull(env, task, obj='bottom', loc=bottom_side_pos)
        if done:
            print("[Task] Task ended during pulling the drawer!")
            return

        print("[Task] Drawer opened successfully!")

        # Move down to the rubbish
        print("[Task] Moving to rubbish location...")
        obs, reward, done = move(env, task, target_pos=rubbish_pos)
        if done:
            print("[Task] Task ended during moving to rubbish!")
            return

        # Pick rubbish
        print("[Task] Picking rubbish...")
        obs, reward, done = pick(env, task, obj='rubbish', loc=rubbish_pos)
        if done:
            print("[Task] Task ended during picking rubbish!")
            return

        # Move to the bin to throw away the rubbish
        print("[Task] Moving to bin...")
        obs, reward, done = move(env, task, target_pos=bin_pos)
        if done:
            print("[Task] Task ended during moving to bin!")
            return

        # Place the rubbish in the bin
        print("[Task] Placing rubbish in the bin...")
        obs, reward, done = place(env, task, obj='rubbish', loc=bin_pos)
        if done:
            print("[Task] Task ended during placing rubbish!")
            return

        print("[Task] Rubbish thrown away successfully!")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")