def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions based on the retrieved data
        rubbish_pos = positions['rubbish']
        bin_pos = positions['bin']
        drawer_pos = positions['drawer']
        
        # Approach the drawer
        print("[Task] Moving to drawer position:", drawer_pos)
        obs, reward, done = move(env, task, target_pos=drawer_pos)
        if done:
            print("[Task] Task ended after moving to drawer!")
            return
        
        # Open the drawer
        print("[Task] Opening drawer")
        obs, reward, done = pick(env, "drawer-handle", drawer_pos)
        if done:
            print("[Task] Task ended after picking the drawer handle!")
            return
        
        # Pull the drawer open
        print("[Task] Pulling drawer open")
        obs, reward, done = pull(env, "drawer")
        if done:
            print("[Task] Task ended after pulling the drawer open!")
            return
        
        # Now pick the rubbish
        print("[Task] Picking up rubbish at:", rubbish_pos)
        obs, reward, done = pick(env, "rubbish", rubbish_pos)
        if done:
            print("[Task] Task ended after picking up the rubbish!")
            return
        
        # Move to the bin to dispose of the rubbish
        print("[Task] Moving to bin position:", bin_pos)
        obs, reward, done = move(env, task, target_pos=bin_pos)
        if done:
            print("[Task] Task ended after moving to bin!")
            return
        
        # Drop the rubbish in the bin
        print("[Task] Dropping rubbish in the bin.")
        obs, reward, done = place(env, "rubbish", bin_pos)
        if done:
            print("[Task] Task completed: Rubbish dropped in bin!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()