def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()
        
        # Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Get drawer positions
        bottom_side_pos = positions['bottom_side_pos']
        middle_side_pos = positions['middle_side_pos']
        top_side_pos = positions['top_side_pos']
        bottom_anchor_pos = positions['bottom_anchor_pos']
        middle_anchor_pos = positions['middle_anchor_pos']
        top_anchor_pos = positions['top_anchor_pos']

        # Open the bottom drawer
        print("[Task] Approaching and opening the bottom drawer.")
        obs, reward, done = move(env, task, obs.robot.position, bottom_side_pos)
        
        if done:
            print("[Task] Task ended while approaching the bottom drawer.")
            return
        
        obs, reward, done = rotate(env, task, bottom_anchor_pos)
        
        if done:
            print("[Task] Task ended while rotating to access the bottom drawer.")
            return
        
        obs, reward, done = pick(env, task, 'bottom_drawer_handle', bottom_side_pos)
        
        if done:
            print("[Task] Task ended while picking the bottom drawer handle.")
            return
        
        obs, reward, done = pull(env, task, 'bottom_drawer')
        
        if done:
            print("[Task] Task ended after pulling the bottom drawer.")
            return
        
        # Repeat for middle drawer
        print("[Task] Approaching and opening the middle drawer.")
        obs, reward, done = move(env, task, obs.robot.position, middle_side_pos)
        
        if done:
            print("[Task] Task ended while approaching the middle drawer.")
            return
        
        obs, reward, done = rotate(env, task, middle_anchor_pos)
        
        if done:
            print("[Task] Task ended while rotating to access the middle drawer.")
            return
        
        obs, reward, done = pick(env, task, 'middle_drawer_handle', middle_side_pos)
        
        if done:
            print("[Task] Task ended while picking the middle drawer handle.")
            return
        
        obs, reward, done = pull(env, task, 'middle_drawer')
        
        if done:
            print("[Task] Task ended after pulling the middle drawer.")
            return
            
        # Repeat for top drawer
        print("[Task] Approaching and opening the top drawer.")
        obs, reward, done = move(env, task, obs.robot.position, top_side_pos)
        
        if done:
            print("[Task] Task ended while approaching the top drawer.")
            return
        
        obs, reward, done = rotate(env, task, top_anchor_pos)
        
        if done:
            print("[Task] Task ended while rotating to access the top drawer.")
            return
        
        obs, reward, done = pick(env, task, 'top_drawer_handle', top_side_pos)
        
        if done:
            print("[Task] Task ended while picking the top drawer handle.")
            return
        
        obs, reward, done = pull(env, task, 'top_drawer')
        
        if done:
            print("[Task] Task ended after pulling the top drawer.")
            return
        
        # Dispose of rubbish on table
        print("[Task] Chucking away rubbish from the table.")
        obs, reward, done = pick(env, task, 'rubbish', obs.robot.position)
        
        if done:
            print("[Task] Task ended while picking the rubbish.")
            return
        
        obs, reward, done = place(env, task, 'rubbish', 'disposal_bin')
        
        if done:
            print("[Task] Task ended while placing the rubbish in the disposal bin.")
            return
        
        print("[Task] Completed all actions successfully.")
        
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()