def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Assume the following objects were defined:
        rubbish_pos = positions['rubbish']
        bin_pos = positions['bin']
        drawer_pos = positions['drawer']  # Hypothetical; update if drawer exists
        gripper = 'gripper_1'  # Placeholder for gripper reference
        
        # Step 1: Move to the drawer to open it (hypothetical action)
        print("[Task] Moving to the drawer.")
        move(env, "current_position", drawer_pos)

        # Step 2: Open the drawer (pick-drawer action)
        print("[Task] Picking the drawer.")
        obs, reward, done = pick_drawing(env, gripper, "drawer", drawer_pos)

        # Verify if drawer is open before trying to access rubbish
        print("[Task] Pulling the drawer open.")
        obs, reward, done = pull(env, gripper, "drawer")

        # Step 3: Move to the rubbish to pick it up
        print("[Task] Moving to the rubbish position.")
        move(env, drawer_pos, rubbish_pos)

        # Step 4: Pick the rubbish 
        print("[Task] Picking the rubbish.")
        obs, reward, done = pick(env, 'rubbish', rubbish_pos, gripper)

        # Step 5: Move to the bin to place the rubbish
        print("[Task] Moving to the bin position.")
        move(env, rubbish_pos, bin_pos)

        # Step 6: Place the rubbish in the bin
        print("[Task] Placing rubbish in the bin.")
        obs, reward, done = place(env, 'rubbish', bin_pos)

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()