import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment
from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Execute the Plan Step-By-Step ===

        # Step 1: Rotate the gripper to face 90 degrees
        target_quat = np.array([0, 0, 1, 0])  # This represents a 90-degree rotation
        obs, reward, done = rotate(env, task, target_quat)

        # Step 2: Move to side position-bottom
        side_pos_bottom = np.array([0.5, 0.0, 0.0])  # Example coordinates for side-pos-bottom
        obs, reward, done = move(env, task, side_pos_bottom)

        # Step 3: Move to anchor position-bottom
        anchor_pos_bottom = np.array([0.5, 0.1, 0.0])  # Example coordinates for anchor-pos-bottom
        obs, reward, done = move(env, task, anchor_pos_bottom)

        # Step 4: Pick the drawer
        obs, reward, done = pick_drawer(env, task, 'gripper', 'bottom', anchor_pos_bottom)

        # Step 5: Pull open the drawer
        obs, reward, done = pull(env, task, 0.15, 'x')  # Adjust pull distance as necessary

        # Step 6: Pick the first tomato from the table
        obs, reward, done = pick(env, task, 'tomato1', 'table')

        # Step 7: Place the first tomato onto the plate
        obs, reward, done = place(env, task, 'tomato1', 'plate')

        # Step 8: Pick the second tomato from the table
        obs, reward, done = pick(env, task, 'tomato2', 'table')

        # Step 9: Place the second tomato onto the plate
        obs, reward, done = place(env, task, 'tomato2', 'plate')

        if done:
            print("[Task] Task completed successfully! Reward:", reward)
        else:
            print("[Task] Task not completed yet (done=False).")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()