import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment
from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions


def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Executing Task Plan ===
        
        # Step 1: Pull open any unlocked drawer
        print("[Task] Pulling open the bottom drawer")
        obs, reward, done = pull(env, task, pull_distance=0.1)  # This action pulls the drawer open
        if done:
            print("[Task] Task ended after pulling the drawer!")

        # Step 2: Pick tomato1 from the table
        print("[Task] Picking up tomato1 from the table")
        obs, reward, done = pick(env, task, target_pos=positions['tomato1'], approach_distance=0.15)  # Pick tomato1
        if done:
            print("[Task] Task ended after picking tomato1!")

        # Step 3: Place tomato1 onto the plate
        print("[Task] Placing tomato1 onto the plate")
        obs, reward, done = place(env, task, target_pos=positions['plate'], approach_distance=0.15)  # Place tomato1 on plate
        if done:
            print("[Task] Task ended after placing tomato1!")

        # Step 4: Pick tomato2 from the table
        print("[Task] Picking up tomato2 from the table")
        obs, reward, done = pick(env, task, target_pos=positions['tomato2'], approach_distance=0.15)  # Pick tomato2
        if done:
            print("[Task] Task ended after picking tomato2!")

        # Step 5: Place tomato2 onto the plate
        print("[Task] Placing tomato2 onto the plate")
        obs, reward, done = place(env, task, target_pos=positions['plate'], approach_distance=0.15)  # Place tomato2 on plate
        if done:
            print("[Task] Task completed successfully!")
        else:
            print("[Task] Task not completed yet.")

    finally:
        # Always ensure the environment is properly shut down
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()