def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Example object positions
        tomato_1_pos = positions['tomato1']
        tomato_2_pos = positions['tomato2']
        drawer_handle_pos = positions['drawer_handle']
        plate_pos = positions['plate']

        # 1) Move to the drawer handle to open it
        print("[Task] Moving to the drawer handle...")
        obs = move(env, obs.gripper, obs.robot_location, drawer_handle_pos)

        # 2) Pull the drawer open
        print("[Task] Pulling the drawer open...")
        obs = pull(env, task, obs.gripper, pull_distance=0.2)

        # 3) Move to pick the first tomato
        print("[Task] Moving to pick tomato1...")
        obs = move(env, obs.gripper, obs.robot_location, tomato_1_pos)

        print("[Task] Picking tomato1...")
        obs = pick(env, 'tomato1', obs.robot_location, obs.gripper)

        # 4) Move to the plate to place the first tomato
        print("[Task] Moving to place tomato1 on plate...")
        obs = move(env, obs.gripper, obs.robot_location, plate_pos)

        print("[Task] Placing tomato1 on plate...")
        obs = place(env, 'tomato1', plate_pos)

        # 5) Move to pick the second tomato
        print("[Task] Moving to pick tomato2...")
        obs = move(env, obs.gripper, obs.robot_location, tomato_2_pos)

        print("[Task] Picking tomato2...")
        obs = pick(env, 'tomato2', obs.robot_location, obs.gripper)

        # 6) Move to place the second tomato on the plate
        print("[Task] Moving to place tomato2 on plate...")
        obs = move(env, obs.gripper, obs.robot_location, plate_pos)

        print("[Task] Placing tomato2 on plate...")
        obs = place(env, 'tomato2', plate_pos)

        print("[Task] Task completed successfully!")

    except Exception as e:
        print(f"An error occurred: {e}")
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()