def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define positions based on assumed structure in the positions dictionary
        bottom_anchor = positions['bottom_anchor_pos']
        middle_anchor = positions['middle_anchor_pos']
        top_anchor = positions['top_anchor_pos']
        drawer = 'drawer'  # Example name for drawer object
        tomato = 'tomato'  # Example name for the object you're manipulating
        plate = 'plate'    # Example name for the target placement

        # Execute Plan Steps
        # 1. Move to the drawer's side position
        print("[Task] Moving to drawer's side position.")
        obs, reward, done = move(env, 'initial_room', bottom_anchor)

        # 2. Pick the drawer handle
        print("[Task] Picking the drawer handle.")
        obs, reward, done = pick(env, drawer, bottom_anchor)

        # 3. Rotate gripper to the desired angle
        print("[Task] Rotating gripper to open drawer.")
        obs, reward, done = rotate(env, task, [0, 0, 0, 1], max_steps=100)

        # 4. Pull the drawer open
        print("[Task] Pulling the drawer open.")
        obs, reward, done = pull(env, drawer)

        # 5. Place the tomato inside the drawer (pick it up first)
        print("[Task] Picking the tomato.")
        obs, reward, done = pick(env, tomato, 'tomato_room')
        
        print("[Task] Placing the tomato on the plate.")
        obs, reward, done = place(env, tomato, plate)

        if done:
            print("[Task] Task completed successfully!")

    except Exception as e:
        print(f"[Error] An error occurred: {e}")
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()