def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assume we have an object to manipulate (e.g., 'object_1', 'drawer_1', etc.)
        # Replace these placeholders with actual object keys.
        gripper = "gripper_1"
        drawer = "drawer_1"
        start_position = positions['start_position']
        end_position = positions['end_position']

        print(f"[Task] Moving to start position: {start_position}")
        obs, reward, done = move(env, "room_a", start_position, max_steps=100)
        
        if done:
            print("[Task] Task ended after moving to start position!")
            return

        print("[Task] Picking object from start position")
        obs, reward, done = pick(env, "object_1", start_position, gripper)

        if done:
            print("[Task] Task ended after picking object!")
            return

        print("[Task] Placing object at end position")
        obs, reward, done = place(env, "object_1", end_position)

        if done:
            print("[Task] Task ended after placing object!")
            return

        print("[Task] Rotating gripper for additional manipulation")
        obs, reward, done = rotate(env, task, target_quat=[0, 0, 0, 1])

        if done:
            print("[Task] Task ended after rotating gripper!")
            return

        print("[Task] Manipulating drawer by picking it.")
        obs, reward, done = pick_drawer(env, gripper, drawer, start_position)

        if done:
            print("[Task] Task ended after picking drawer!")
            return

        print("[Task] Pulling drawer to open it.")
        obs, reward, done = pull(env, gripper, drawer)

        if done:
            print("[Task] Task ended after pulling drawer!")
            return

        print("[Task] Manipulation complete.")
    
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()