def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Extracting positions based on naming conventions
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        plate_pos = positions['plate']
        drawer_pos = positions['drawer']

        # === Task Execution Plan ===
        
        # 1. Move to the drawer
        print("[Task] Moving to drawer at:", drawer_pos)
        obs, reward, done = move(env, 'robot', 'current_position', drawer_pos)
        if done:
            print("[Task] Task ended after moving to drawer!")
            return

        # 2. Open the drawer (rotate gripper, pull handle)
        print("[Task] Opening the drawer.")
        obs, reward, done = rotate(env, task, 'desired_orientation')  # Determine the target orientation based on your setup
        if done:
            print("[Task] Task ended during rotation!")
            return
            
        obs, reward, done = pull(env, 'robot', 'drawer')
        if done:
            print("[Task] Task ended after pulling on drawer handle!")
            return

        # 3. Pick up tomatoes
        print("[Task] Picking up tomato1.")
        obs, reward, done = pick(env, 'tomato1', 'drawer')
        if done:
            print("[Task] Task ended after picking up tomato1!")
            return
        
        print("[Task] Picking up tomato2.")
        obs, reward, done = pick(env, 'tomato2', 'drawer')
        if done:
            print("[Task] Task ended after picking up tomato2!")
            return

        # 4. Move to the plate
        print("[Task] Moving to plate at:", plate_pos)
        obs, reward, done = move(env, 'robot', 'drawer', plate_pos)
        if done:
            print("[Task] Task ended after moving to plate!")
            return

        # 5. Place tomatoes on the plate
        print("[Task] Placing tomato1 on the plate.")
        obs, reward, done = place(env, 'tomato1', 'plate')
        if done:
            print("[Task] Task ended after placing tomato1!")
            return
            
        print("[Task] Placing tomato2 on the plate.")
        obs, reward, done = place(env, 'tomato2', 'plate')
        if done:
            print("[Task] Task ended after placing tomato2!")
            return

        print("[Task] All tasks completed successfully!")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()