def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define positions for the task
        drawer_pos = positions['drawer']  # Assuming the drawer's position is retrieved
        gripper_pos = positions['gripper']  # Assuming the gripper's position is available

        # Step 1: Move to Drawer Position
        print("[Task] Moving to drawer position:", drawer_pos)
        obs, reward, done = move(env, gripper_pos, drawer_pos)
        if done:
            print("[Task] Error occurred during moving to drawer position.")
            return

        # Step 2: Pick the Drawer Handle
        print("[Task] Picking the drawer handle.")
        obs, reward, done = pick(env, 'drawer_handle', drawer_pos)
        if done:
            print("[Task] Task ended after picking the drawer handle!")
            return

        # Step 3: Pull the Drawer Open
        print("[Task] Pulling the drawer open.")
        obs, reward, done = pull(env, task, pull_distance=0.2)  # Assuming pulling distance
        if done:
            print("[Task] Task ended during pulling the drawer!")
            return

        # Step 4: Place the Drawer Handle Back
        print("[Task] Placing the drawer handle back.")
        obs, reward, done = place(env, 'drawer_handle', drawer_pos)
        if done:
            print("[Task] Task ended after placing the drawer handle!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()