def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Extract the positions for tomatoes and drawer
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        drawer_pos = positions['drawer']  # Assume this is the position of the drawer
        plate_pos = positions['plate']  # Position of the plate

        # Step 1: Move to the drawer's side position
        print("[Task] Moving to drawer's side position...")
        obs, reward, done = move(env, task, obs['gripper_position'], drawer_pos)

        # Step 2: Pull open the drawer if it's not locked
        print("[Task] Attempting to pull the drawer...")
        obs, reward, done = pull(env, task, pull_distance=0.1)  # Assuming some pull distance
        
        # Check if the drawer is opened successfully
        if done:
            print("[Task] Drawer opened!")
        else:
            print("[Task] Failed to open the drawer!")
            return
        
        # Step 3: Pick the first tomato
        print("[Task] Picking up tomato 1...")
        obs, reward, done = pick(env, 'tomato1', obs['current_location'], gripper='gripper')
        
        if done:
            print("[Task] Picked tomato 1 successfully!")
        else:
            print("[Task] Failed to pick tomato 1!")
            return
        
        # Step 4: Place tomato 1 on the plate
        print("[Task] Placing tomato 1 on the plate...")
        obs, reward, done = place(env, 'tomato1', plate_pos)
        
        if done:
            print("[Task] Placed tomato 1 on the plate successfully!")
        else:
            print("[Task] Failed to place tomato 1 on the plate!")
            return
        
        # Step 5: Pick the second tomato
        print("[Task] Picking up tomato 2...")
        obs, reward, done = pick(env, 'tomato2', obs['current_location'], gripper='gripper')
        
        if done:
            print("[Task] Picked tomato 2 successfully!")
        else:
            print("[Task] Failed to pick tomato 2!")
            return
        
        # Step 6: Place tomato 2 on the plate
        print("[Task] Placing tomato 2 on the plate...")
        obs, reward, done = place(env, 'tomato2', plate_pos)
        
        if done:
            print("[Task] Placed tomato 2 on the plate successfully!")
        else:
            print("[Task] Failed to place tomato 2 on the plate!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")