def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have `drawer_1`, `gripper_1`, and the relevant positions
        drawer_pos = positions['drawer_1']
        gripper_pos = positions['gripper_1']
        
        # Step 1: Move the robot to the drawer position
        print("[Task] Moving to drawer position:", drawer_pos)
        obs, reward, done = move(env, 'current_room', drawer_pos)
        if done:
            print("[Task] Ended after moving to drawer position!")
            return
        
        # Step 2: Pick the drawer
        print("[Task] Picking the drawer.")
        obs, reward, done = pick(env, 'drawer_object', drawer_pos, 'gripper_1')
        if done:
            print("[Task] Ended after picking the drawer!")
            return
        
        # Step 3: Pull the drawer
        print("[Task] Pulling the drawer.")
        obs, reward, done = pull(env, 'gripper_1', 'drawer_object', drawer_pos)
        if done:
            print("[Task] Ended after pulling the drawer!")
            return
        
        # Step 4: Rotate the gripper for different operations if needed
        target_quat = [0, 0, 0, 1]  # Placeholder for the target rotation
        print("[Task] Rotating the gripper.")
        obs, reward, done = rotate(env, task, target_quat)
        if done:
            print("[Task] Ended after rotating the gripper!")
            return
        
        # Step 5: Place the drawer/object back if necessary
        print("[Task] Placing the drawer back.")
        obs, reward, done = place(env, 'drawer_object', drawer_pos)
        if done:
            print("[Task] Ended after placing the drawer!")
            return
        
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()