def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Define the initial positions of the objects
        tomato_pos = positions['tomato']
        plate_pos = positions['plate']
        drawer_pos = positions['drawer']

        # Execute the task plan
        # Step 1: Move to the position of the tomato
        print("[Task] Moving to tomato's position:", tomato_pos)
        obs, reward, done = move(env, task, obs['robot_position'], tomato_pos)
        if done:
            print("[Task] Task ended while moving to tomato!")
            return

        # Step 2: Pick the tomato
        print("[Task] Picking up the tomato...")
        obs, reward, done = pick(env, 'tomato', drawer_pos, obs['gripper'])
        if done:
            print("[Task] Task ended while picking tomato!")
            return

        # Step 3: Move to the position of the plate
        print("[Task] Moving to the plate's position:", plate_pos)
        obs, reward, done = move(env, task, obs['robot_position'], plate_pos)
        if done:
            print("[Task] Task ended while moving to plate!")
            return

        # Step 4: Place the tomato on the plate
        print("[Task] Placing the tomato on the plate...")
        obs, reward, done = place(env, 'tomato', plate_pos)
        if done:
            print("[Task] Task ended while placing tomato!")
            return

        print("[Task] Task completed successfully!")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()