def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Defining the key objects based on assumptions
        tomato_pos = positions['tomato']  # Assume we know the objects
        drawer_pos = positions['drawer']
        gripper = 'gripper'  # The gripper object name or ID
        robot = 'robot'  # The robot name or ID

        # Plan execution based on the domain and initial observations

        # Step 1: Move to the drawer location to interact with it
        print("[Task] Moving to the drawer...")
        obs, reward, done = move(env, robot, obs.robot_location, drawer_pos)
        if done:
            print("[Task] Task ended after moving to the drawer!")
            return
        
        # Step 2: Approach and pick the drawer handle
        print("[Task] Picking the drawer handle...")
        obs, reward, done = pick(env, 'drawer handle', drawer_pos, gripper)
        if done:
            print("[Task] Task ended after picking the drawer handle!")
            return
        
        # Step 3: Pull the drawer open
        print("[Task] Pulling the drawer to open it...")
        obs, reward, done = pull(env, gripper, 'drawer', drawer_pos)
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

        # Step 4: Move to the tomato position to pick it up
        print("[Task] Moving to the tomato...")
        obs, reward, done = move(env, robot, drawer_pos, tomato_pos)
        if done:
            print("[Task] Task ended after moving to the tomato!")
            return
        
        # Step 5: Picking up the tomato
        print("[Task] Picking the tomato...")
        obs, reward, done = pick(env, 'tomato', tomato_pos, gripper)
        if done:
            print("[Task] Task ended after picking the tomato!")
            return
        
        # Step 6: Placing the tomato in a specified location
        print("[Task] Placing the tomato down...")
        obs, reward, done = place(env, 'tomato', drawer_pos)
        if done:
            print("[Task] Task ended after placing the tomato!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()