def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Define object positions based on the assumed initial setup
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        plate_pos = positions['plate']
        drawer_pos = positions['bottom']  # Assuming you have a drawer
        
        # Approach the drawer position
        print("[Task] Moving to drawer position:", drawer_pos)
        obs, reward, done = move(env, obs.robot_location, drawer_pos)
        if done:
            return
        
        # Pick up the drawer using the gripper
        print("[Task] Picking up the drawer")
        obs, reward, done = pick(env, 'drawer', drawer_pos)
        if done:
            return
            
        # Pull the drawer open
        print("[Task] Pulling the drawer to open")
        obs, reward, done = pull(env, 'drawer', drawer_pos)
        if done:
            return
        
        # Now pick the first tomato
        print("[Task] Picking up first tomato")
        obs, reward, done = pick(env, 'tomato1', tomato1_pos)
        if done:
            return
        
        # Place the first tomato on the plate
        print("[Task] Placing first tomato on the plate")
        obs, reward, done = place(env, 'tomato1', plate_pos)
        if done:
            return
        
        # Now pick the second tomato
        print("[Task] Picking up second tomato")
        obs, reward, done = pick(env, 'tomato2', tomato2_pos)
        if done:
            return
        
        # Place the second tomato on the plate
        print("[Task] Placing second tomato on the plate")
        obs, reward, done = place(env, 'tomato2', plate_pos)
        if done:
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()