def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming 'drawer' and 'tomato' are the required objects in the positions dictionary
        bottom_drawer_pos = positions['bottom_drawer']
        middle_drawer_pos = positions['middle_drawer']
        tomato_pos = positions['tomato']

        # Step 1: Move to the bottom drawer to check its status
        print("[Task] Moving to bottom drawer")
        obs, reward, done = move(env, task, bottom_drawer_pos)

        # Step 2: Pick the drawer if it's available
        print("[Task] Picking bottom drawer")
        obs, reward, done = pick(env, 'bottom_drawer', bottom_drawer_pos, 'gripper')

        # Step 3: Open the drawer
        print("[Task] Pulling bottom drawer")
        obs, reward, done = pull(env, 'bottom_drawer')

        # Step 4: Move to the tomatoes
        print("[Task] Moving to tomato position")
        obs, reward, done = move(env, task, tomato_pos)

        # Step 5: Pick the tomato
        print("[Task] Picking tomato")
        obs, reward, done = pick(env, 'tomato', tomato_pos, 'gripper')

        # Step 6: Place the tomato onto the plate (assuming a plate position exists)
        plate_pos = positions['plate']  # Assuming the plate's position is available
        print("[Task] Placing tomato on plate")
        obs, reward, done = place(env, 'tomato', plate_pos)

        if done:
            print("[Task] Task ended successfully!")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()