def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions from the problem's initial state
        bottom_drawer_pos = positions['bottom_drawer']
        middle_drawer_pos = positions['middle_drawer']
        top_drawer_pos = positions['top_drawer']
        bottom_anchor_pos = positions['bottom_anchor_pos']
        middle_anchor_pos = positions['middle_anchor_pos']
        top_anchor_pos = positions['top_anchor_pos']
        
        # === Task Execution Plan ===
        
        # Move to the bottom drawer
        print("[Task] Moving to bottom drawer at:", bottom_drawer_pos)
        obs, reward, done = move(env, task, target_pos=bottom_drawer_pos)
        if done:
            print("[Task] Task ended while moving to the bottom drawer!")
            return

        # Pick the bottom drawer
        print("[Task] Picking bottom drawer")
        obs, reward, done = pick(env, 'bottom', bottom_drawer_pos)
        if done:
            print("[Task] Task ended while picking the bottom drawer!")
            return
        
        # Pull the bottom drawer
        print("[Task] Pulling bottom drawer")
        obs, reward, done = pull(env, 'bottom', bottom_drawer_pos)
        if done:
            print("[Task] Task ended while pulling the bottom drawer!")
            return

        # Move to the anchor position of the bottom drawer
        print("[Task] Moving to bottom drawer anchor position at:", bottom_anchor_pos)
        obs, reward, done = move(env, task, target_pos=bottom_anchor_pos)
        if done:
            print("[Task] Task ended while moving to the bottom drawer anchor position!")
            return

        # Move to the tomatoes inside the bottom drawer
        print("[Task] Moving to tomatoes in bottom drawer")
        obs, reward, done = move(env, task, target_pos=(bottom_drawer_pos[0], bottom_drawer_pos[1] - 0.1, bottom_drawer_pos[2]))
        if done:
            print("[Task] Task ended while moving to tomatoes!")
            return

        # Pick the tomatoes
        print("[Task] Picking tomatoes")
        obs, reward, done = pick(env, 'tomatoes', bottom_drawer_pos)
        if done:
            print("[Task] Task ended while picking tomatoes!")
            return

        # Place the tomatoes onto the plate
        print("[Task] Moving to plate to place tomatoes")
        obs, reward, done = move(env, task, target_pos=(0.5, 0.5, 0))  # Assuming plate is at (0.5, 0.5, 0)
        if done:
            print("[Task] Task ended while moving to the plate!")
            return
        
        print("[Task] Placing tomatoes on the plate")
        obs, reward, done = place(env, 'tomatoes', (0.5, 0.5, 0))  # Place them on the plate
        if done:
            print("[Task] Task ended while placing tomatoes!")
            return
        
        print("[Task] Successfully completed the task.")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()