def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")

    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Defining object positions for clarity
        gripper_position = positions['gripper']
        drawer_position = positions['drawer']
        tomato1_position = positions['tomato1']
        tomato2_position = positions['tomato2']
        plate_position = positions['plate']

        # Task Plan Execution
        print("[Task] Moving to gripper position.")
        obs, reward, done = move(env, gripper_position, drawer_position) 
        
        if done:
            print("[Task] Task ended early when moving to the gripper position!")
            return
        
        print("[Task] Picking up the drawer handle.")
        obs, reward, done = pick(env, 'handle', drawer_position, 'gripper')
        
        if done:
            print("[Task] Task ended early when picking the drawer handle!")
            return
        
        print("[Task] Pulling the drawer open.")
        obs, reward, done = pull(env, 'drawer', drawer_position, 'gripper')

        if done:
            print("[Task] Task ended early when pulling the drawer!")
            return
        
        print("[Task] Picking up tomatoes.")
        obs, reward, done = pick(env, 'tomato1', drawer_position, 'gripper')
        
        if done:
            print("[Task] Task ended early when picking up tomato1!")
            return

        print("[Task] Placing tomato1 on the plate.")
        obs, reward, done = place(env, 'tomato1', plate_position)

        if done:
            print("[Task] Task ended early when placing tomato1!")
            return

        print("[Task] Picking up tomato2.")
        obs, reward, done = pick(env, 'tomato2', drawer_position, 'gripper')

        if done:
            print("[Task] Task ended early when picking up tomato2!")
            return

        print("[Task] Placing tomato2 on the plate.")
        obs, reward, done = place(env, 'tomato2', plate_position)

        if done:
            print("[Task] Task ended early when placing tomato2!")
            return

        print("[Task] Task completed successfully!")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()