def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        # Example usage: positions = 'object_1': (0,0,0), 'object_2': (1,1,1), ... (dictionary format)
        positions = get_object_positions()

        # Extract positions of relevant objects
        drawer_pos = positions.get('drawer1', None)  # Replace 'drawer1' with the actual drawer object key
        tomato1_pos = positions.get('tomato1', None)
        tomato2_pos = positions.get('tomato2', None)
        plate_pos = positions.get('plate', None)

        if None in (drawer_pos, tomato1_pos, tomato2_pos, plate_pos):
            print("One or more required object positions are unavailable.")
            return

        # Step 1: Move to the drawer
        print("[Task] Moving to the drawer.")
        obs, reward, done = move(env, 'current_room', 'drawer_room')  # Assuming 'drawer_room' is where the drawer is
        if done:
            return

        # Step 2: Pick the drawer
        print("[Task] Picking the drawer handle.")
        obs, reward, done = pick(env, 'drawer_handle', 'drawer_room', 'gripper')
        if done:
            return

        # Step 3: Pull the drawer open
        print("[Task] Pulling the drawer open.")
        obs, reward, done = pull(env, task, pull_distance=0.2)  # Adjust pull_distance as needed
        if done:
            return

        # Step 4: Pick up first tomato
        print("[Task] Picking up the first tomato.")
        obs, reward, done = pick(env, 'tomato1', 'drawer_room', 'gripper')
        if done:
            return

        # Step 5: Move towards the plate
        print("[Task] Moving to the plate.")
        obs, reward, done = move(env, 'drawer_room', 'plate_room')  # Assuming 'plate_room' is where the plate is
        if done:
            return

        # Step 6: Place the first tomato on the plate
        print("[Task] Placing the first tomato on the plate.")
        obs, reward, done = place(env, 'tomato1', 'plate_room')
        if done:
            return
        
        # Step 7: Repeat for the second tomato
        print("[Task] Picking up the second tomato.")
        obs, reward, done = pick(env, 'tomato2', 'drawer_room', 'gripper')
        if done:
            return

        print("[Task] Moving to the plate.")
        obs, reward, done = move(env, 'drawer_room', 'plate_room')
        if done:
            return

        print("[Task] Placing the second tomato on the plate.")
        obs, reward, done = place(env, 'tomato2', 'plate_room')
        if done:
            return

        print("[Task] Finished placing all tomatoes on the plate.")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()