def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions based on the environment context
        bottom_side_pos = positions['bottom_side_pos']
        bottom_anchor_pos = positions['bottom_anchor_pos']
        plate_pos = positions['plate_pos']
        rubbish_pos = positions['rubbish_pos']
        tomato1_pos = positions['tomato1_pos']
        tomato2_pos = positions['tomato2_pos']

        # === Task Plan Execution ===
        print("[Task] Moving to the bottom anchor position to open the drawer.")
        obs, reward, done = move(env, 'nowhere-pos', bottom_anchor_pos)
        if done:
            print("[Task] Task ended after moving to the anchor position!")
            return

        print("[Task] Picking the drawer.")
        obs, reward, done = pick(env, 'drawer', bottom_anchor_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking the drawer!")
            return

        print("[Task] Pulling the drawer open.")
        obs, reward, done = pull(env, 'drawer', bottom_anchor_pos)
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

        print("[Task] Picking tomato1 from the drawer.")
        obs, reward, done = pick(env, 'tomato1', bottom_side_pos)
        if done:
            print("[Task] Task ended after picking tomato1!")
            return

        print("[Task] Placing tomato1 on the plate.")
        obs, reward, done = place(env, 'tomato1', plate_pos)
        if done:
            print("[Task] Task ended after placing tomato1!")
            return

        print("[Task] Picking tomato2 from the drawer.")
        obs, reward, done = pick(env, 'tomato2', bottom_side_pos)
        if done:
            print("[Task] Task ended after picking tomato2!")
            return

        print("[Task] Placing tomato2 on the plate.")
        obs, reward, done = place(env, 'tomato2', plate_pos)
        if done:
            print("[Task] Task ended after placing tomato2!")
            return

        print("[Task] Task completed successfully!")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()