def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assign the object positions based on the keys from the initial state
        drawer_pos = positions['drawer']
        tomato_pos_1 = positions['tomato1']
        tomato_pos_2 = positions['tomato2']
        plate_pos = positions['plate']
        bottom_side_pos = positions['bottom_side_pos']
        bottom_anchor_pos = positions['bottom_anchor_pos']

        # Assuming the plan is to slide the drawer open and toss tomatoes to the plate:

        # Step 1: Move the robot to the drawer's position
        print("[Task] Moving to the drawer position.")
        obs, reward, done = move(env, obs['robot'], obs['robot_position'], drawer_pos)

        if done:
            print("[Task] Task ended after moving to the drawer position!")
            return

        # Step 2: Move gripper to the side position before opening the drawer
        print("[Task] Moving gripper to the side position to grab the drawer.")
        obs, reward, done = move(env, obs['gripper'], obs['gripper_position'], bottom_side_pos)

        if done:
            print("[Task] Task ended after moving gripper to the side position!")
            return

        # Step 3: Pick the drawer
        print("[Task] Picking the drawer.")
        obs, reward, done = pick(env, "drawer_handle", drawer_pos, obs['gripper'])

        if done:
            print("[Task] Task ended after picking the drawer!")
            return

        # Step 4: Pull the drawer open
        print("[Task] Pulling the drawer open.")
        obs, reward, done = pull(env, obs['gripper'], obs['drawer_handle'], drawer_pos)

        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

        # Step 5: Pick the first tomato and toss it to the plate
        print("[Task] Picking the first tomato.")
        obs, reward, done = pick(env, "tomato1", tomato_pos_1, obs['gripper'])

        if done:
            print("[Task] Task ended after picking the first tomato!")
            return

        print("[Task] Tossing the first tomato onto the plate.")
        obs, reward, done = place(env, "tomato1", plate_pos)

        if done:
            print("[Task] Task ended after tossing the first tomato onto the plate!")
            return

        # Step 6: Pick the second tomato and toss it to the plate
        print("[Task] Picking the second tomato.")
        obs, reward, done = pick(env, "tomato2", tomato_pos_2, obs['gripper'])

        if done:
            print("[Task] Task ended after picking the second tomato!")
            return

        print("[Task] Tossing the second tomato onto the plate.")
        obs, reward, done = place(env, "tomato2", plate_pos)

        if done:
            print("[Task] Task ended after tossing the second tomato onto the plate!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()