def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")

    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Sample object positions for manipulation
        object1_pos = positions['object_1']
        object2_pos = positions['object_2']
        drawer_pos = positions['drawer_1']

        # Approach the first object and pick it up
        obs, reward, done = move(env, task, from_room='initial_room', to_room=object1_pos)
        if done:
            print("[Task] Task ended after moving to object 1 location!")
            return

        obs, reward, done = pick(env, 'object_1', 'object1_location', 'gripper_1')
        if done:
            print("[Task] Task ended after picking object 1!")
            return
        
        # Move to drawer and place the object
        obs, reward, done = move(env, task, from_room=object1_pos, to_room=drawer_pos)
        if done:
            print("[Task] Task ended after moving to drawer!")
            return

        obs, reward, done = place(env, 'object_1', 'drawer_1')
        if done:
            print("[Task] Task ended after placing object 1 in drawer!")
            return

        # Approach and pick up a second object
        obs, reward, done = move(env, task, from_room='initial_room', to_room=object2_pos)
        if done:
            print("[Task] Task ended after moving to object 2 location!")
            return

        obs, reward, done = pick(env, 'object_2', 'object2_location', 'gripper_1')
        if done:
            print("[Task] Task ended after picking object 2!")
            return

        # Move back to drawer and place the second object
        obs, reward, done = move(env, task, from_room=object2_pos, to_room=drawer_pos)
        if done:
            print("[Task] Task ended after moving to drawer!")
            return

        obs, reward, done = place(env, 'object_2', 'drawer_1')
        if done:
            print("[Task] Task ended after placing object 2 in drawer!")
            return

        print("[Task] Completed all actions successfully!")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()