def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # TODO: Define the target positions for drawer and plate
        drawer_position = positions['drawer']
        plate_position = positions['plate']
        tomato1_position = positions['tomato1']
        tomato2_position = positions['tomato2']
        
        # Start manipulating the drawer
        print("[Task] Moving to the drawer position:", drawer_position)
        obs, reward, done = move(env, obs.robot_position, drawer_position)
        if done:
            print("[Task] Task ended after moving to the drawer position!")
            return
        
        # Rotate the gripper to align
        print("[Task] Rotating gripper to align with drawer handle")
        obs = rotate(env, task, target_quat=[0, 0, 0, 1])  # Assuming some target quaternion for alignment
        
        # Open the drawer
        print("[Task] Picking the drawer to open")
        obs, reward, done = pick_door(env, obs.robot_position, drawer_position)
        if done:
            print("[Task] Task ended after attempting to pick the drawer!")
            return
        
        print("[Task] Pulling the drawer to open")
        obs, reward, done = pull(env, obs.robot_position, drawer_position)
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return
            
        # Move to pick the first tomato
        print("[Task] Moving to pick the first tomato at:", tomato1_position)
        obs, reward, done = move(env, obs.robot_position, tomato1_position)
        if done:
            print("[Task] Task ended after moving to first tomato!")
            return
            
        print("[Task] Picking the first tomato")
        obs, reward, done = pick(env, 'tomato1', tomato1_position)
        if done:
            print("[Task] Task ended after picking the first tomato!")
            return
            
        # Move to place the first tomato on the plate
        print("[Task] Moving to place the first tomato on the plate at:", plate_position)
        obs, reward, done = move(env, obs.robot_position, plate_position)
        if done:
            print("[Task] Task ended after moving to plate!")
            return
            
        print("[Task] Placing the first tomato on the plate")
        obs, reward, done = place(env, 'tomato1', plate_position)
        if done:
            print("[Task] Task ended after placing the first tomato!")
            return
            
        # Repeat for the second tomato
        print("[Task] Moving to pick the second tomato at:", tomato2_position)
        obs, reward, done = move(env, obs.robot_position, tomato2_position)
        if done:
            print("[Task] Task ended after moving to second tomato!")
            return
            
        print("[Task] Picking the second tomato")
        obs, reward, done = pick(env, 'tomato2', tomato2_position)
        if done:
            print("[Task] Task ended after picking the second tomato!")
            return
            
        # Move to place the second tomato on the plate
        print("[Task] Moving to place the second tomato on the plate at:", plate_position)
        obs, reward, done = move(env, obs.robot_position, plate_position)
        if done:
            print("[Task] Task ended after moving to plate!")
            return
            
        print("[Task] Placing the second tomato on the plate")
        obs, reward, done = place(env, 'tomato2', plate_position)
        if done:
            print("[Task] Task ended after placing the second tomato!")
            return
            
        print("[Task] All tomatoes successfully placed on the plate!")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()