def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assume we have object 'drawer1' and the robot is at 'room1'
        robot_position = positions['robot_start']  # Replace with actual robot start position key
        drawer_position = positions['drawer1']  # Replace with actual drawer position key
        object_to_pick = 'object1'  # Example object to manipulate
        
        # Move to the drawer
        print("[Task] Moving to drawer position:", drawer_position)
        obs, reward, done = move(env, robot_position, drawer_position)
        if done:
            print("[Task] Task ended after moving to drawer!")
            return

        # Pick the object from the drawer
        print("[Task] Picking object:", object_to_pick)
        obs, reward, done = pick(env, object_to_pick, drawer_position, 'gripper')  # Assume 'gripper' is the name of our gripper
        if done:
            print("[Task] Task ended after picking object!")
            return

        # Now we could place it somewhere else or perform additional actions
        destination_position = positions['destination']  # Replace with actual destination position key
        print("[Task] Placing object at destination:", destination_position)
        obs, reward, done = place(env, object_to_pick, destination_position)
        if done:
            print("[Task] Task ended after placing object!")
            return

        # Optionally, rotate gripper at the final position if needed
        print("[Task] Rotating gripper to final orientation.")
        target_quat = [0, 0, 0, 1]  # Dummy value; replace with actual target quaternion
        obs, reward, done = rotate(env, task, target_quat)
        if done:
            print("[Task] Task ended after rotating gripper!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()