def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Assume the drawer and tomatoes are part of the environment setup
        drawer_pos = positions['drawer']  # Replace with the correct drawer object name
        tomato1_pos = positions['tomato1']  # Replace with the correct tomato object name
        tomato2_pos = positions['tomato2']  # Replace with the correct tomato object name
        
        # Step 1: Move to the drawer
        print("[Task] Moving to the drawer:")
        obs, reward, done = move(env, 'current_room', drawer_pos)
        if done:
            print("[Task] Task ended after moving to the drawer!")
            return
        
        # Step 2: Open the drawer
        print("[Task] Picking the drawer handle.")
        obs, reward, done = pick(env, 'drawer_handle', drawer_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking the drawer handle!")
            return
        
        print("[Task] Pulling the drawer open.")
        obs, reward, done = pull(env, 'gripper', 'drawer')  # Assuming pull opens the drawer
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

        # Step 3: Pick tomatoes
        print("[Task] Picking tomato 1.")
        obs, reward, done = pick(env, 'tomato1', drawer_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking tomato 1!")
            return

        print("[Task] Placing tomato 1 on the plate.")
        obs, reward, done = place(env, 'tomato1', 'plate_pos')  # Replace with correct plate position
        if done:
            print("[Task] Task ended after placing tomato 1!")
            return

        print("[Task] Picking tomato 2.")
        obs, reward, done = pick(env, 'tomato2', drawer_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking tomato 2!")
            return

        print("[Task] Placing tomato 2 on the plate.")
        obs, reward, done = place(env, 'tomato2', 'plate_pos')  # Replace with correct plate position
        if done:
            print("[Task] Task ended after placing tomato 2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()