def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Define your objects (replace with actual object names and positions)
        # For instance, assume we have drawer and gripper defined in the position data.
        drawer_pos = positions['drawer_1']
        gripper_pos = positions['gripper_1']

        # Simulation steps
        print("[Task] Moving to drawer position.")
        obs, reward, done = move(env, 'initial_room', drawer_pos)

        if done:
            print("[Task] Task ended before manipulating drawer.")
            return

        print("[Task] Picking from drawer.")
        obs, reward, done = pick(env, 'object_1', drawer_pos, 'gripper_1')

        if done:
            print("[Task] Task ended after picking object.")
            return

        print("[Task] Placing object.")
        obs, reward, done = place(env, 'object_1', 'final_room')

        if done:
            print("[Task] Task ended after placing object.")
            return

        print("[Task] Rotating gripper for next action.")
        obs, reward, done = rotate(env, task, target_quat='desired_orientation')

        if done:
            print("[Task] Task ended after rotation.")
            return

        print("[Task] Pulling drawer.")
        obs, reward, done = pull(env, 'gripper_1', 'drawer_1')

        if done:
            print("[Task] Task ended after pulling the drawer.")
            return

        print("[Task] Finished sequence of actions. Task is complete!")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()