def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assume the drawer is identified as 'drawer1' and it has 'closed' state initially
        drawer_pos = positions['drawer1']
        
        # Move to the drawer's position
        print("[Task] Moving to drawer position:", drawer_pos)
        obs, reward, done = move(env, task, obs['robot_position'], drawer_pos)

        if done:
            print("[Task] Task ended after moving to drawer!")
            return
        
        # Check if the drawer is locked or open and handle accordingly
        # Assume we need to pick the drawer using a gripper 'gripper1'
        print("[Task] Picking the drawer handle.")
        obs, reward, done = pick(env, 'drawer_handle', drawer_pos, 'gripper1')

        if done:
            print("[Task] Task ended after picking the drawer handle!")
            return
        
        # Now pull the drawer to open it
        print("[Task] Pulling the drawer open.")
        obs, reward, done = pull(env, task, pull_distance=0.2, pull_axis='x', max_steps=100)

        if done:
            print("[Task] Task ended after pulling the drawer!")
            return
        
        # Assuming we have tomatoes to place on the plate
        tomato_pos = positions['tomato1']
        plate_pos = positions['plate']

        # Move to the tomato's position
        print("[Task] Moving to tomato position:", tomato_pos)
        obs, reward, done = move(env, task, obs['robot_position'], tomato_pos)

        if done:
            print("[Task] Task ended after moving to tomato position!")
            return
        
        # Pick up the tomato
        print("[Task] Picking up the tomato.")
        obs, reward, done = pick(env, 'tomato1', tomato_pos, 'gripper1')

        if done:
            print("[Task] Task ended after picking the tomato!")
            return
        
        # Move to the plate's position
        print("[Task] Moving to plate position:", plate_pos)
        obs, reward, done = move(env, task, obs['robot_position'], plate_pos)

        if done:
            print("[Task] Task ended after moving to plate position!")
            return
        
        # Drop the tomato onto the plate
        print("[Task] Dropping the tomato onto the plate.")
        obs, reward, done = place(env, 'tomato1', plate_pos)

        if done:
            print("[Task] Task ended after placing the tomato!")
            return
        
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()