def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Assuming we have the following positions and objects:
        gripper = "gripper_1"
        drawer = "drawer_1"
        side_position = "side_position_1"
        anchor_position = "anchor_position_1"

        # Step 1: Move the gripper to the side position near the drawer
        print("[Task] Moving to side position:", side_position)
        obs, reward, done = move(env, gripper, "current_position", side_position)
        if done:
            print("[Task] Task ended while moving to side position.")
            return

        # Step 2: Rotate the gripper to the required angle
        print("[Task] Rotating gripper to position.")
        target_angle = "ninety_deg"  # Example target angle
        obs, reward, done = rotate(env, task, target_angle)
        if done:
            print("[Task] Task ended while rotating the gripper.")
            return

        # Step 3: Pick the drawer
        print("[Task] Picking the drawer.")
        obs, reward, done = pick_drawer(env, gripper, drawer, anchor_position)
        if done:
            print("[Task] Task ended while picking the drawer.")
            return
        
        # Step 4: Pull the drawer open
        print("[Task] Pulling the drawer open.")
        obs, reward, done = pull(env, gripper, drawer)
        if done:
            print("[Task] Task ended while pulling the drawer open.")
            return

        # You can add additional steps to manipulate items in the drawer as needed.

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()