import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *  # using predefined skills: move, pick, place, rotate, pull
from video import init_video_writers, recording_step, recording_get_observation

# This module is assumed to provide object positions or other info about the environment
from object_positions import get_object_positions


def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Example object positions (assumed names)
        drawer_position = positions['drawer_pos']
        tomato_position = positions['tomato_pos']
        plate_position = positions['plate_pos']
        side_pos_bottom = positions['bottom_side_pos']
        anchor_pos_bottom = positions['bottom_anchor_pos']

        # Sequence of actions to achieve the goal
        print("[Task] Move to drawer to pick tomato")
        obs, reward, done = move(env, 'robot', 'room', drawer_position)
        if done: return

        print("[Task] Open the drawer")
        obs, reward, done = pick(env, 'drawer', 'room')
        if done: return
        
        print("[Task] Pull the drawer open")
        obs, reward, done = pull(env, 'robot', 'drawer', drawer_position)
        if done: return

        print("[Task] Pick the tomato from the drawer")
        obs, reward, done = pick(env, 'tomato', drawer_position)
        if done: return

        print("[Task] Move to the plate to place the tomato")
        obs, reward, done = move(env, 'robot', drawer_position, plate_position)
        if done: return

        print("[Task] Place the tomato on the plate")
        obs, reward, done = place(env, 'tomato', plate_position)
        if done: return
        
        print("[Task] Completed placing the tomato.")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()