def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Defining key positions based on the exploration and environment
        table_pos = positions['table']
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        gripper_pos = positions['gripper_initial']

        # Example Task Plan (Generic)
        # Step 1: Move to the table
        print("[Task] Moving to the table.")
        obs, reward, done = move(env, gripper_pos, table_pos)
        if done:
            print("[Task] Task ended after moving to the table!")
            return

        # Step 2: Pick tomato1
        print("[Task] Picking up tomato1.")
        obs, reward, done = pick(env, 'tomato1', table_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking tomato1!")
            return

        # Step 3: Move to the drop location
        drop_location = positions['drop_location']
        print("[Task] Moving to drop location.")
        obs, reward, done = move(env, table_pos, drop_location)
        if done:
            print("[Task] Task ended after moving to drop location!")
            return

        # Step 4: Place tomato1
        print("[Task] Placing tomato1.")
        obs, reward, done = place(env, 'tomato1', drop_location)
        if done:
            print("[Task] Task ended after placing tomato1!")
            return
            
        # Step 5: Pick tomato2
        print("[Task] Picking up tomato2.")
        obs, reward, done = pick(env, 'tomato2', table_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking tomato2!")
            return

        # Step 6: Move to the drop location
        print("[Task] Moving to drop location.")
        obs, reward, done = move(env, table_pos, drop_location)
        if done:
            print("[Task] Task ended after moving to drop location!")
            return

        # Step 7: Place tomato2
        print("[Task] Placing tomato2.")
        obs, reward, done = place(env, 'tomato2', drop_location)
        if done:
            print("[Task] Task ended after placing tomato2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()