def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Extract specific object positions
        bottom_drawer_pos = positions.get('bottom_drawer', None)
        middle_drawer_pos = positions.get('middle_drawer', None)
        top_drawer_pos = positions.get('top_drawer', None)
        plate_pos = positions.get('plate', None)

        # Open the bottom drawer
        print("[Task] Opening the bottom drawer at:", bottom_drawer_pos)
        # Move to the position of the bottom drawer
        obs, reward, done = move(env, task, obs.robot_position, bottom_drawer_pos)
        if done:
            print("[Task] Task ended while moving to the bottom drawer!")
            return
        
        # Rotate gripper to the appropriate angle if necessary
        print("[Task] Rotating gripper to open the drawer")
        target_quat = # Define the appropriate quaternion for opening
        obs, reward, done = rotate(env, task, target_quat)
        if done:
            print("[Task] Task ended while rotating gripper!")
            return
        
        # Now we need to pull the drawer to open it
        print("[Task] Pulling the bottom drawer to open it")
        obs, reward, done = pull(env, task, bottom_drawer_pos)
        if done:
            print("[Task] Task ended while pulling the drawer!")
            return
        
        # Pick all tomatoes from the drawer
        tomato_positions = [pos for obj, pos in positions.items() if 'tomato' in obj]  # Get all tomato positions
        for tomato_pos in tomato_positions:
            print(f"[Task] Picking tomato at: {tomato_pos}")
            obs, reward, done = pick(env, task, 'tomato', tomato_pos)
            if done:
                print("[Task] Task ended while picking a tomato!")
                return
        
            # Place the tomato on the plate
            print(f"[Task] Placing tomato on the plate at: {plate_pos}")
            obs, reward, done = place(env, task, 'tomato', plate_pos)
            if done:
                print("[Task] Task ended while placing a tomato!")
                return

        # Optionally, add further actions as required by the task

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()