def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we need to move to the first object and pick it up
        obj1_pos = positions['object_1']  # Adjust this to match actual object keys
        obj2_pos = positions['object_2']  # Adjust for additional objects as necessary
        
        # Move to object_1
        print(f"[Task] Moving to object_1 at: {obj1_pos}")
        obs, reward, done = move(env, task, current_location, obj1_pos) 
        if done:
            print("[Task] Task ended after moving to object_1!")
            return
            
        # Pick object_1
        print(f"[Task] Picking object_1 at: {obj1_pos}")
        obs, reward, done = pick(env, 'object_1', 'room_a', 'gripper')
        if done:
            print("[Task] Task ended after picking object_1!")
            return
        
        # Move to object_2
        print(f"[Task] Moving to object_2 at: {obj2_pos}")
        obs, reward, done = move(env, task, obj1_pos, obj2_pos)
        if done:
            print("[Task] Task ended after moving to object_2!")
            return
        
        # Place object_1 at location of object_2
        print(f"[Task] Placing object_1 at: {obj2_pos}")
        obs, reward, done = place(env, 'object_1', 'room_b')
        if done:
            print("[Task] Task ended after placing object_1!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()